package fp.test;

import junit.framework.TestCase;
import fp.*;
import brs.*;

/**
 * Tests Leaf.Singleton on non-empty trees.
 * @author DXN
 */
public class TestLeaf extends TestCase {
    static final ILambda leaf = Leaf.Singleton;
    
    /**
     */
    public void test_apply() {
        BiTree bt = new BiTree();                
//        int isLeaf = (Integer)leaf.apply(bt);
//        System.out.println(bt + "\nisLeaf: " + isLeaf + '\n');
//        assertEquals("Empty Tree", 0, isLeaf);
        
        bt.insertRoot(5);
        int isLeaf = (Integer)leaf.apply(bt);
        System.out.println(bt + "\nisLeaf: " + isLeaf + '\n');
        assertEquals("One-element Tree", 1, isLeaf);
        
        bt.getLeftSubTree().insertRoot(-2);
        isLeaf = (Integer)leaf.apply(bt);
        System.out.println(bt + "\nisLeaf: " + isLeaf + '\n');
        assertEquals("empty right subtree, non-empty left subtree", 0, isLeaf);
        
        bt.getLeftSubTree().remRoot();
        bt.getRightSubTree().insertRoot(10);
        isLeaf = (Integer)leaf.apply(bt);
        System.out.println(bt + "\nisLeaf: " + isLeaf + '\n');
        assertEquals("empty left subtree, non-empty right subtree", 0, isLeaf);
        
        bt.getLeftSubTree().insertRoot(-2);
        isLeaf = (Integer)leaf.apply(bt);
        System.out.println(bt + "\nisLeaf: " + isLeaf + '\n');
        assertEquals("non-empty left subtree, non-empty right subtree", 0, isLeaf);
    }
    
}
