package maze.visitor;

import listFW.*;
import listFW.visitor.*;
import listFW.factory.*;
import maze.*;

public class FindEnd implements IRoomAlgo<IList<IRoom>,Object> {
  public static final FindEnd Singleton  = new FindEnd();
  private FindEnd() {}
  
  /**
   * Factory to use to make the path list.
   */
  private IListFactory<IRoom> fac = new CompositeListFactory<IRoom>();
  
  /**
   * Returns an empty list b/c there is no path through an empty room.
   */
  public IList<IRoom> emptyCase(IEmptyRoom roomHost, Object... nu) {
    // STUDENT TO COMPLETE
    return fac.makeEmptyList();
  }
  
  /**
   * Returns  list of rooms that is the path to the end room starting at this room.
   * Path includes both this room and the end room.   
   * Path is empty if there is no route to the end room through this room.
   */
  public IList<IRoom> neCase(final INERoom roomHost, Object... nu) {
    // STUDENT TO COMPLETE
    return roomHost.getData().execute(new IRoomDataAlgo<IList<IRoom>, Object>() {
      
      public IList<IRoom> endCase(IRoomData dataHost, Object... inps) {
        return fac.makeNEList(roomHost, fac.makeEmptyList());
      }
      
      public IList<IRoom> seenCase(IRoomData dataHost, Object... inps) {
        return fac.makeEmptyList();
      }
      
      
      /**
       * Defines the invariant nonEmptyCase for processing the recursive 
       * results.
       * Helper is defined here so that roomHost is in its closure.
       */
      abstract class ResultHelper implements IListAlgo<IRoom, IList<IRoom>, Object> {
        public IList<IRoom> nonEmptyCase(INEList<? extends IRoom> resultHost, Object... nu){
          return fac.makeNEList(roomHost, resultHost);
        }
      };
      
      public IList<IRoom> unseenCase(IRoomData dataHost, Object... inps) {
        roomHost.setData(IRoomData.SEEN);
        return roomHost.exitNorth().execute(FindEnd.this)
          .execute(new ResultHelper() { 
          public IList<IRoom> emptyCase(IMTList<? extends IRoom> northResultHost, Object... nu) {
            return roomHost.exitEast().execute(FindEnd.this)
              .execute(new ResultHelper() {
              public IList<IRoom> emptyCase(IMTList<? extends IRoom> eastResultHost, Object... nu) {
                return roomHost.exitSouth().execute(FindEnd.this)
                  .execute(new ResultHelper() {
                  public IList<IRoom> emptyCase(IMTList<? extends IRoom> southResultHost, Object... nu) {
                    return roomHost.exitWest().execute(FindEnd.this)
                      .execute(new ResultHelper() {
                      public IList<IRoom> emptyCase(IMTList<? extends IRoom> westResultHost, Object... nu) {
                        return fac.makeEmptyList(); 
                      }
                    });
                  }
                });
              }
            });
          }
          // non-empty case is invariant, so no need to override.
        });
      }
    });
  }
}