package maze.visitor;

import maze.*;

public class ResetToUnseen implements IRoomAlgo<IRoom, Object> {
  public static final ResetToUnseen Singleton = new ResetToUnseen();
  private ResetToUnseen() {}
  
  public IRoom emptyCase(IEmptyRoom host, Object... nu) {
    return host;
  }
  
  private IRoomDataAlgo<INERoom, INERoom> helper = new IRoomDataAlgo<INERoom, INERoom>() {
    public INERoom endCase(IRoomData h, INERoom... roomHost) {
      return roomHost[0];
    }
    public INERoom unseenCase(IRoomData h, INERoom... roomHost) {
      return roomHost[0];
    }
    public INERoom seenCase(IRoomData h, INERoom... roomHost) {
      roomHost[0].setData(IRoomData.UNSEEN);
      return roomHost[0];
    }
  };
  public IRoom neCase(INERoom host, Object... nu) {
    return host.getData().execute(helper, host);
  }
}