
package brs;

/**
 * Represents the empty state of a BiTree.  Uses the singleton pattern to model
 * the uniqueness of "emptiness".
 * @author Dung X. Nguyen - Copyright 2002 - All rights reserved.
 * @since 03/11/02
 */
class EmptyNode extends ANode {

    final static EmptyNode Singleton = new EmptyNode ();

    private EmptyNode (){
    }

    /**
    * Throws java.util.NoSuchElementException.
    * @param owner the BiTree holding this EmptyNode.
    */
    Object getRootDat (BiTree owner) {
        throw new java.util.NoSuchElementException ("EmptyNode.getRootDat()");
    }

    /**
    * Throws java.util.NoSuchElementException.
    * @param dat a data Object.
    * @param owner the BiTree holding this EmptyNode.
    */
    void setRootDat (Object dat, BiTree owner) {
        throw new java.util.NoSuchElementException ("EmptyNode.setRootDat()");
    }

    /**
    * Throws java.util.NoSuchElementException.
    * @param owner the BiTree holding this EmptyNode.
    */
    BiTree getLeftSubTree (BiTree owner) {
        throw new java.util.NoSuchElementException ("EmptyNode.getLeftSubTree()");
    }

    /**
    * Throws java.util.NoSuchElementException.
    * @param owner the BiTree holding this EmptyNode.
    */
    BiTree getRightSubTree(BiTree owner) {
        throw new java.util.NoSuchElementException ("EmptyNode.getRightSubTree()");
    }

    /**
    * Throws java.util.NoSuchElementException.
    * @param biTree a given BiTree.
    * @param owner the BiTree holding this EmptyNode.
    */
    void setLeftSubTree(BiTree biTree, BiTree owner) {
        throw new java.util.NoSuchElementException ("EmptyNode.setLeftSubTree()");
    }

    /**
    * Throws java.util.NoSuchElementException.
    * @param biTree a given BiTree.
    * @param owner the BiTree holding this EmptyNode.
    */
    void setRightSubTree(BiTree biTree, BiTree owner) {
        throw new java.util.NoSuchElementException ("EmptyNode.setRightSubTree()");
    }

    /**
    * Asks the owner tree to set the root node to a new DatNode containing dat,
    * resulting in a state change from empty to non-empty.
    * @param dat a given data Object.
    * @param owner the context of this state.
    */
    void insertRoot(Object dat, BiTree owner) {
        owner.setRootNode(new DatNode(dat));
    }

    /**
    * Throws java.util.NoSuchElementException.
    * @param owner the BiTree holding this EmptyNode.
    */
    Object remRoot (BiTree owner) {
        throw new java.util.NoSuchElementException ("EmptyNode.remRoot()");
    }

    /**
    * Calls algo's emptyCase () method to execute the algorithm algo.
    * @param algo the visiting algorithm
    * @param inp the input algo needs.
    * @param owner the BiTree holding this EmptyNode.
    * @return the output for the emptyCase() of algo.
    */
    Object execute(BiTree owner, IVisitor algo, Object... inp) {
        return algo.emptyCase(owner, inp);
    }
}

