package listFW.visitor;

import listFW.*;

/**
 * Copies an IList<T> using the an IListFactory<T> supplied as an input parameter 
 */
public class CopyList3<T> implements IListAlgo<T,IList<T>, IListFactory<T>> {
    
    public  IMTList<T> emptyCase(IMTList<? extends T> host, IListFactory<T> ... fac) {
        return fac[0].makeEmptyList(); 
    }
    public    INEList<T> nonEmptyCase(INEList<? extends T> host, IListFactory<T> ... fac) {
        return fac[0].makeNEList( host.getFirst(), host.getRest().execute(this, fac)); 
    }
}
