package lrs;

/**
 * Represents an abstract algorithm on an LRStruct.  Acts as a visitor to a
 * LRStruct host.
 * @author Dung X. Nguyen and Stephen Wong  Copyright 2005 - All rights reserved.
 * @since 8/25/05
 */
public interface IAlgo {
    /**
    * Operates on an empty LRStruct host, given an input object.
    * @param host an empty LRStruct.
    * @param inp variable input list of objects needed by this IVisitor.
    * @return an appropriate output object.
    */
    public abstract Object emptyCase(LRStruct host, Object... inp);

    /**
    * Operates on a non-empty LRStruct host, given an input object.
    * @param host a non-empty LRStruct.
    * @param inp variable input list of objects needed by this IVisitor.
    * @return an appropriate output object.
    */
    public abstract Object nonEmptyCase(LRStruct host, Object... inp);
}

