package lrs.lazyLRSEvaluators;

import lrs.*;
import fp.*;

public class LazyDiffLambdaEval extends ALazyEval
{
  private LRStruct src;
  
  public LazyDiffLambdaEval(LRStruct aSrc) {
    src = aSrc;
  }
  
  public final LRStruct nextLRS()
  {
    // STUDENT TO COMPLETE
    
    // Delegate to the src list
    return (LRStruct) src.execute(new IAlgo() {
      public Object emptyCase(LRStruct srcHost, Object... nu) {
        // Differential of an empty polynomial is an empty polynomial.
        return new LRStruct();
      }
      public Object nonEmptyCase(LRStruct srcHost, Object... nu) {
        // Advance the src list and make a new polynomial.
        src = srcHost.getRest();
        return makeLRS();
      }
    });
  }
  
  public final LRStruct makeLRS()
  {
    // STUDENT TO COMPLETE

    // Delegate to the src list.
    return (LRStruct) src.execute(new IAlgo() {
      public Object emptyCase(LRStruct srcHost, Object... nu) {
        // Differential of an empty polynomial is an empty polynomial.
        return new LRStruct();  
      }
      public Object nonEmptyCase(LRStruct srcHost, Object... nu) {
        IPowerFn pf = (IPowerFn) src.getFirst();  // get the current term
        if( 0.0 == pf.getPower()) {
          return nextLRS();  // get rid of constant term.
        }
        else {
          // Perform the differentiation and make a new lazy list.
          return makeLazyLRS ( new PowerFn(pf.getCoef()*pf.getPower(), pf.getPower()-1.0));
        }
      }
    });
  }
}
                                  
                                  
                                  
                                  
