package lrs.lazyLRSEvaluators;

import lrs.*;
import lrs.visitor.*; 


/**
 * LAzy evaluator that consumes a given source list 
 * using a given algorithm to produce the lazy list.
 */
public class LazyListConsumer extends ALazyEval {
  
  private LRStruct src;
  
  /**
   * Algo that will return a new src list where the next element
   * is the first element in the new src list.
   * The algorithm (visitor) is executed by the current source list to 
   * produce a new list whose first is the next lazy list value
   * and whose rest is the next source list.
   * 
   */
  private IAlgo newSrcAlgo;
  
  /**
   * Constructor for the class
   * @param src  The source list to use
   * @param newSrcAlgo The visitor to use to transform the source list to the new source list with the next value as its first.
   */
  public LazyListConsumer(LRStruct src, IAlgo newSrcAlgo) {
    this.src = src;
    this.newSrcAlgo = newSrcAlgo;
  }
  
  /**
   * Inductive case construction of the lazy list
   */
  public LRStruct nextLRS() {
    // STUDENT TO COMPLETE
    return null;  // Stub code
  }
  
  /**
   * Base case construction of the lazy list
   */
  public LRStruct makeLRS() {
    // STUDENT TO COMPLETE
    
    return null;  // Stub code
  }
}


