package lrs.visitor;

import lrs.*;

/**
 * Replaces the first element of a list with 
 * the average of the first n elements of the list
 * If the list has fewer than n elements, the 
 * average is correctly calculated for that number of 
 * elements.
 */
public class LRSRunningAvg implements IAlgo{
  /**
   * The depth to average over
   */
  private int maxCount=0;
  
  /**
   * Constructor for the class.
   * @param n The number of elements to average, at most
   */
  public LRSRunningAvg(int n) {
    maxCount = n;
  }
  
  public Object emptyCase(LRStruct host, Object... nu) {
    return host;
  }
  
  public Object nonEmptyCase(LRStruct host, Object... nu) {
    final double[] divisor = new double[]{1};
    
    double recurResult = (Double) host.getRest().execute(new IAlgo() {
      public Object emptyCase(LRStruct h, Object... count) {
        divisor[0] = (Integer)count[0];
        return 0.0;
      }
      
      public Object nonEmptyCase(LRStruct h, Object... count) {
        int cnt = 1+(Integer) count[0];
        if(cnt == maxCount) {
          divisor[0] = maxCount;
          return h.getFirst();
        }
        else
        {
          double rr = ((Number) h.getRest().execute(this, cnt)).doubleValue();
          return rr+((Number)h.getFirst()).doubleValue();
        }
      }      
    }, 1);
    host.setFirst((recurResult+((Number)host.getFirst()).doubleValue())/divisor[0]);
    return host;
  }
}