package listFW.visitor;

import listFW.*;
import listFW.factory.*;

/**
 * Appends a value of type T on the end of the host,
 * using a CompositeListFactory<T>
 */
public class AppendList<T> implements IListAlgo<T,IList<T>, T> {
  
  private IListFactory<T> fac = new CompositeListFactory<T>();
  
  public  INEList<T> emptyCase(IMTList<? extends T> host, T ... inps) {
    return fac.makeNEList(inps[0], fac.makeEmptyList());
  }
  
  public    INEList<T> nonEmptyCase(INEList<? extends T> host, T ... inps) {
    return fac.makeNEList(host.getFirst(), host.getRest().execute(this, inps)); // Generates "unchecked cast" warning
  }
}
