package maze.visitor.test;

import maze.*;
import maze.visitor.*;
import listFW.*;
import listFW.factory.*;
import trinket.*;
import junit.framework.TestCase;


public class FindTrinket_Test extends TestCase {
  
  
  public static void test_FindTrinket() {
    IListFactory<ITrinket> fac = new CompositeListFactory<ITrinket>();
    IRoom start = RoomFactory.Singleton.makeMaze(10);
    
    System.out.println("Maze, before the FindTrinket algorithm has been through it:");
    System.out.println("start = \n"+start.execute(MazeToString.Singleton));
    
    ITrinket trinket = ITrinket.NULL;
    IList<IRoom> path = start.execute(FindTrinket.Singleton, trinket);
    System.out.println("path to "+trinket+"= \n"+path);
    
//    System.out.println("Maze, after the FindEnd algorithm has been through it:");
//    System.out.println("start = \n"+start.execute(MazeToString.Singleton));
    
    trinket = ITrinket.COIN;
    path = start.execute(FindTrinket.Singleton, trinket);
    System.out.println("path to "+trinket+"= \n"+path);
    
//    System.out.println("Maze, after the FindEnd algorithm has been through it:");
//    System.out.println("start = \n"+start.execute(MazeToString.Singleton));
   
    trinket = ITrinket.WAND;
    path = start.execute(FindTrinket.Singleton, trinket);
    System.out.println("path to "+trinket+"= \n"+path);
//    System.out.println("Maze, after the FindEnd algorithm has been through it:");
//    System.out.println("start = \n"+start.execute(MazeToString.Singleton));
    
    trinket = ITrinket.FOOD;
    path = start.execute(FindTrinket.Singleton, trinket);
    System.out.println("path to "+trinket+"= \n"+path);
//    System.out.println("Maze, after the FindEnd algorithm has been through it:");
//    System.out.println("start = \n"+start.execute(MazeToString.Singleton));
    
    trinket = ITrinket.KEY;
    path = start.execute(FindTrinket.Singleton, trinket);
    System.out.println("path to "+trinket+"= \n"+path);
    System.out.println("Maze, after the FindTrinket algorithm has been through it:");
    System.out.println("start = \n"+start.execute(MazeToString.Singleton));
    System.out.println("\n\n");

  }
  
}
