package trinket;

/**
 * An algorithm on an ITrinket
 * Has cases for 5 concrete types of ITrinket:
 * NULL, COIN, WAND, FOOD, and KEY
 */
public interface ITrinketAlgo<R, P> {
  public R nullCase(ITrinket t, P... inps);
  public R coinCase(ITrinket t, P... inps);
  public R wandCase(ITrinket t, P... inps);
  public R foodCase(ITrinket t, P... inps);
  public R keyCase(ITrinket t, P... inps);
}