package trinket.test;

import trinket.*;
import logic.*;
import maze.*;

import junit.framework.TestCase;


public class Trinket_Test extends TestCase {
  
  public void test_TrinketEquals() {
    IBooleanAlgo<String, IRoom, Object> boolAlgo = new IBooleanAlgo<String, IRoom, Object>() {
      public String trueCase(IRoom host, Object... inps) {
        return host.getName() +": "+inps[0];
      }
      public String falseCase(IRoom host, Object... inps) {
        return host.getName() +": "+inps[1];
      };
    };
    
    IRoom mtRoom = RoomFactory.Singleton.makeEmptyRoom();
    
    TrinketEquals<String, IRoom> algo = new TrinketEquals<String, IRoom> ();
    
    assertEquals("Coin-Coin", "[]: Equal", ITrinket.COIN.execute(algo, ITrinket.COIN, boolAlgo, mtRoom, "Equal", "Not Equal"));
    assertEquals("Coin-Wand", "[]: Not Equal", ITrinket.COIN.execute(algo, ITrinket.WAND, boolAlgo, mtRoom, "Equal", "Not Equal"));
    assertEquals("Wand-Wand", "[]: Equal", ITrinket.WAND.execute(algo, ITrinket.WAND, boolAlgo, mtRoom, "Equal", "Not Equal"));
  }
}
