package fp;

public class PowerFn implements IPowerFn {
  private double n; 
  private double c;
  
  public PowerFn(double coef, double power) {
    n = power;
    c = coef;
  }
  
  public Object apply(Object ... params) {
    return c*Math.pow(((Number) params[0]).doubleValue(),n);
  }
  
  public double getPower() {
    return n;
  }
  
  public double getCoef() {
    return c;
  }
  
  public String toString() {
    return c+"x^"+n;
  }
}