package lrs;

import lrs.lazyLRSEvaluators.*;
/**
 * Decorator for NonNullState, adding lazy evaluation capability.
 * @author D. X. Nguyen & S. B. Wong
 */
public class LazyNonNullState extends ANode{
  ALazyEval aLazyEval;
  NENode neNode;
  
  LazyNonNullState(Object first, ALazyEval aLazyEval) {
    neNode = new NENode (first, new LRStruct());
    this.aLazyEval = aLazyEval;
  }
  
  LRStruct getRest(LRStruct owner) {
    eval (owner);
    return (neNode.getRest (owner));
  }
  
  LRStruct setRest(LRStruct tail, LRStruct owner) {
    eval (owner);
    return neNode.setRest (tail, owner);
  }
  
  LRStruct setFirst(Object first, LRStruct owner) {
    return neNode.setFirst (first, owner);
  }
  
  LRStruct insertFront(Object dat, LRStruct owner) {
    return neNode.insertFront (dat, owner);
  }
  
  Object removeFront(LRStruct owner) {
    eval (owner);
    return (neNode.removeFront (owner));
  }
  
  void eval(LRStruct owner) {
    owner.setHead (neNode);  // owner no longer needs lazy eval.
    owner.setRest (aLazyEval.nextLRS ());   // But owner's tail does!
  }
  
  Object getFirst(LRStruct owner) {
    return (neNode.getFirst (owner)); // lazy eval not needed.
  }
  
  Object execute(LRStruct host, IAlgo visitor, Object... param)  {
    return (neNode.execute (host, visitor, param));
  }
}

