package lrs.visitor;

import lrs.*;

public class LRSRemoveRandom implements IAlgo{
  public static LRSRemoveRandom Singleton = new LRSRemoveRandom();
  
  private LRSRemoveRandom() { }
  
  public Object emptyCase(LRStruct host, Object... param) {
    return host;
  }
  
  public Object nonEmptyCase(final LRStruct host, Object... param) {
    host.getRest().execute(new IAlgo() {
      public Object emptyCase(LRStruct h, Object... acc) {
        int numElts = (Integer)acc[0];
        return (int)(numElts*Math.random());
      }
      
      public Object nonEmptyCase(LRStruct h, Object... acc) {
        Object remIdx = h.getRest().execute(this, 1+(Integer)acc[0]);
        if(remIdx.equals(acc[0])) host.insertFront(h.removeFront());
        return remIdx;
      }      
    }, 1);
    return host;
  }
}