package lrs.visitor;

import lrs.*;

/**
 * Randomly selects an element from the list and 
 * moves it to the front of the list;
 * On average, the element is chosen from a given 
 * distance back, with an exponentially decreasing
 * probability in distance.
 */
public class LRSRemoveRandomExp implements IAlgo{
  /**
   * The probablility of not choosing a given element
   */
  private double prob=1.0;
  
  /**
   * Constructor for the class
   * @param length The expectation value for the number elements skipped before choosing the element to move to the front of the list.
   */
  public LRSRemoveRandomExp(double length) {
    prob = length/(1.0+length);
  }
  
  public Object emptyCase(LRStruct host, Object... nu) {
    return host;
  }
  
  public Object nonEmptyCase(final LRStruct host, Object... nu) {
    if(prob > Math.random()) {
      host.getRest().execute(new IAlgo() {
        public Object emptyCase(LRStruct h, Object... prev) {
          return host.insertFront(((LRStruct)prev[0]).removeFront());
        }
        
        public Object nonEmptyCase(LRStruct h, Object... prev) {
          if(prob < Math.random()){
            return host.insertFront(h.removeFront());
          }
          else {
            return h.getRest().execute(this, h);
          }
        }      
      }, host);
    }
    return host;
  }
}