package listFW.visitor;

import listFW.*;
import listFW.factory.*;

/**
 * Appends a list holding a sub-type of T on the end of the host,
 * using a CompositeListFactory<T>
 */
public class AppendLists<T> implements IListAlgo<T,IList<T>, IList<? extends T>> {
  
  private IListFactory<T> fac = new CompositeListFactory<T>();
  
  public  INEList<T> emptyCase(IMTList<? extends T> host, IList<? extends T> ... inps) {
    return (INEList<T>)inps[0];
  }
  
  public    INEList<T> nonEmptyCase(INEList<? extends T> host, IList<? extends T> ... inps) {
    return fac.makeNEList(host.getFirst(), host.getRest().execute(this, inps)); // Generates "unchecked cast" warning
  }
}
