package maze.visitor;

import listFW.*;
import listFW.visitor.*;
import listFW.factory.*;
import maze.*;
import trinket.*;
import logic.*;

/**
 * Finds a path from a the host IRoom to another room that holds the given Trinket
 * Returns a list of IRooms that is the path from the starting room to the desired room
 * The returned path is not guaranteed to be the shortest path.
 * inps[0] is the ITrinket to find
 */
public class FindTrinket implements IRoomAlgo<IList<IRoom>,ITrinket> {
  public static final FindTrinket Singleton  = new FindTrinket();
  private FindTrinket() {}
  
  /**
   * Factory to use to make the path list.
   */
  private IListFactory<IRoom> fac = new CompositeListFactory<IRoom>();
  
  /**
   * Returns an empty list b/c there is no path through an empty room.
   */
  public IList<IRoom> emptyCase(IEmptyRoom roomHost, ITrinket... nu) {
    // STUDENT TO COMPLETE
    return fac.makeEmptyList();
  }
  
  /**
   * Returns  list of rooms that is the path to the room with the given trinket starting at this room.
   * Path includes both this room and the end room.   
   * Path is empty if there is no route to the end room through this room.
   */
  public IList<IRoom> neCase(final INERoom roomHost, final ITrinket... trinkets) {
    // STUDENT TO COMPLETE

        return roomHost.getData().execute(new IRoomDataAlgo<IList<IRoom>, Object>() {
          
          public IList<IRoom> endCase(IRoomData dataHost, Object... inps) {
            return unseenCase(dataHost, inps); //fac.makeNEList(roomHost, fac.makeEmptyList());
          }
          
          public IList<IRoom> seenCase(IRoomData dataHost, Object... inps) {
            return fac.makeEmptyList();
          }
          
          
          /**
           * Defines the invariant nonEmptyCase for processing the recursive 
           * results.
           * Helper is defined here so that roomHost is in its closure.
           */
          abstract class ResultHelper implements IListAlgo<IRoom, IList<IRoom>, Object> {
            public IList<IRoom> nonEmptyCase(INEList<? extends IRoom> resultHost, Object... nu){
              return fac.makeNEList(roomHost, resultHost);
            }
          };
          
          public IList<IRoom> unseenCase(IRoomData dataHost, Object... inps) {
            IRoomData oldData = roomHost.getData();
            roomHost.setData(IRoomData.SEEN);
            
            IList<IRoom> path = roomHost.getTrinket().execute(new TrinketEquals<IList<IRoom>, IRoom>() {
            }, trinkets[0], new IBooleanAlgo<IList<IRoom>, IRoom, Object>() {
              public IList<IRoom> trueCase(IRoom host, Object...p) {
                return fac.makeNEList(roomHost, fac.makeEmptyList());
              }
              public IList<IRoom> falseCase(IRoom host, Object...p) {
                return roomHost.exitNorth().execute(FindTrinket.this, trinkets)
                  .execute(new ResultHelper() { 
                  public IList<IRoom> emptyCase(IMTList<? extends IRoom> northResultHost, Object... nu) {
                    return roomHost.exitEast().execute(FindTrinket.this, trinkets)
                      .execute(new ResultHelper() {
                      public IList<IRoom> emptyCase(IMTList<? extends IRoom> eastResultHost, Object... nu) {
                        return roomHost.exitSouth().execute(FindTrinket.this, trinkets)
                          .execute(new ResultHelper() {
                          public IList<IRoom> emptyCase(IMTList<? extends IRoom> southResultHost, Object... nu) {
                            return roomHost.exitWest().execute(FindTrinket.this, trinkets)
                              .execute(new ResultHelper() {
                              public IList<IRoom> emptyCase(IMTList<? extends IRoom> westResultHost, Object... nu) {
                                return fac.makeEmptyList(); 
                              }
                            });
                          }
                        });
                      }
                    });
                  }
                  // non-empty case is invariant, so no need to override.
                });               
              }
            }, roomHost);
            
            roomHost.setData(oldData);
            return path;
          }
        });
      }
}