package trinket;

/**
 * Represents a trinket that can be put in the maze
 */
public interface ITrinket {
  
  /**
   * executes a visitor to a trinket
   */
  public <R, P> R execute(ITrinketAlgo<R, P> algo, P... inps);
  
  
  /**
   * The null trinket, representing no trinket.
   */
  public static final ITrinket NULL = new ITrinket() {
    public <R, P> R execute(ITrinketAlgo<R, P> algo, P... inps) {
      return algo.nullCase(this, inps);
    };
    public String toString() {
      return "Null";
    }
  };
  
  /**
   * A concrete singleton trinket
   */
  public static final ITrinket COIN = new ITrinket() {
    public <R, P> R execute(ITrinketAlgo<R, P> algo, P... inps) {
      return algo.coinCase(this, inps);
    };
    
    public String toString() {
      return "Coin";
    }
  };
  
  /**
   * A concrete singleton trinket
   */
  public static final ITrinket WAND = new ITrinket() {
    public <R, P> R execute(ITrinketAlgo<R, P> algo, P... inps) {
      return algo.wandCase(this, inps);
    };

    public String toString() {
      return "Wand";
    }
  };
  
  /**
   * A concrete singleton trinket
   */
  public static final ITrinket FOOD = new ITrinket() {
    public <R, P> R execute(ITrinketAlgo<R, P> algo, P... inps) {
      return algo.foodCase(this, inps);
    };

    public String toString() {
      return "Food";
    }
  };
  
  /**
   * A concrete singleton trinket
   */
  public static final ITrinket KEY = new ITrinket() {
    public <R, P> R execute(ITrinketAlgo<R, P> algo, P... inps) {
      return algo.keyCase(this, inps);
    };

    public String toString() {
      return "Key";
    }
  };
}