package trinket;

import logic.*;

/**
 * Compares two ITrinkets for equality, returning the results of the 
 * the trueCase of the supplied IBooleanAlgo visitor if the two trinkets
 * are the same or the result of the falseCase if not.
 * inps[0] other ITrinket
 * inps[1] IBooleanAlgo
 * inps[2] host for IBooleanAlgo
 * inps[3], inps[4], etc  vararg parameters passed to the IBooleanAlgo visitor
 * @param <R> The type of the returned value
 * @param <H> The type of the host for the IBooleanAlgo
 */
public class TrinketEquals<R, H> implements ITrinketAlgo<R, Object> {
  
  /**
   * Internal abstract class that gives default, not equals behavoir.
   */
  private abstract class ACompare<R, H> implements  ITrinketAlgo<R, Object> {
      public R nullCase(ITrinket t, Object... inps) {
        return ((IBooleanAlgo<R,H,Object>)inps[1]).falseCase((H)inps[2], trimArray(inps));
      }
      public R coinCase(ITrinket t, Object... inps){
        return ((IBooleanAlgo<R,H,Object>)inps[1]).falseCase((H)inps[2], trimArray(inps));
      }
      public R wandCase(ITrinket t, Object... inps){
        return ((IBooleanAlgo<R,H,Object>)inps[1]).falseCase((H)inps[2], trimArray(inps));
      }
      public R foodCase(ITrinket t, Object... inps) {
        return ((IBooleanAlgo<R,H,Object>)inps[1]).falseCase((H)inps[2], trimArray(inps));
      }
      public R keyCase(ITrinket t, Object... inps) {
        return ((IBooleanAlgo<R,H,Object>)inps[1]).falseCase((H)inps[2], trimArray(inps));
      }
  }
  
  /**
   * The host trinket is null.  Delegate to the supplied trinket.
   */
  public R nullCase(ITrinket t, Object... inps) {
    return ((ITrinket)inps[0]).execute(new ACompare<R, Object>(){
      /**
       * Override the nullCase to return the result of the IBooleanAlgo's
       * trueCase.
       */
      public R nullCase(ITrinket t, Object... inps) {
        return ((IBooleanAlgo<R,H,Object>)inps[1]).trueCase((H)inps[2], trimArray(inps));
      }
    }, inps); 
  }  

  /**
   * The host trinket is a COIN.  Delegate to the supplied trinket.
   */
  public R coinCase(ITrinket t, Object... inps) {
    return ((ITrinket)inps[0]).execute(new ACompare<R, Object>(){
      /**
       * Override the coinCase to return the result of the IBooleanAlgo's
       * trueCase.
       */
      public R coinCase(ITrinket t, Object... inps){
        return ((IBooleanAlgo<R,H,Object>)inps[1]).trueCase((H)inps[2], trimArray(inps));
      }
    }, inps); 
  }  

  /**
   * The host trinket is a WAND.  Delegate to the supplied trinket.
   */
  public R wandCase(ITrinket t, Object... inps) {
    return ((ITrinket)inps[0]).execute(new ACompare<R, Object>(){
      /**
       * Override the wandCase to return the result of the IBooleanAlgo's
       * trueCase.
       */
      public R wandCase(ITrinket t, Object... inps){
        return ((IBooleanAlgo<R,H,Object>)inps[1]).trueCase((H)inps[2], trimArray(inps));
      }
    }, inps); 
  }  
  
  /**
   * The host trinket is a FOOD.  Delegate to the supplied trinket.
   */
  public R foodCase(ITrinket t, Object... inps) {
    return ((ITrinket)inps[0]).execute(new ACompare<R, Object>(){
      /**
       * Override the foodCase to return the result of the IBooleanAlgo's
       * trueCase.
       */
      public R foodCase(ITrinket t, Object... inps) {
        return ((IBooleanAlgo<R,H, Object>)inps[1]).trueCase((H)inps[2], trimArray(inps));
      }
    }, inps); 
  }  
  
  /**
   * The host trinket is a KEY.  Delegate to the supplied trinket.
   */
  public R keyCase(ITrinket t, Object... inps) {
    return ((ITrinket)inps[0]).execute(new ACompare<R, Object>(){
      /**
       * Override the keyCase to return the result of the IBooleanAlgo's
       * trueCase.
       */
      public R keyCase(ITrinket t, Object... inps) {
        return ((IBooleanAlgo<R,H, Object>)inps[1]).trueCase((H)inps[2], trimArray(inps));
      }
    }, inps); 
  }
  
  /**
   * Utility method to trim the first three arguments off the vararg parameter list
   * Used to prepare the vararg inputs to the IBooleanAlgo
   */
  private Object[] trimArray(Object[] inps) {
    Object[] result = new Object[inps.length-3];
    System.arraycopy(inps, 3, result, 0, result.length);
    return  result;
  }
}