
package lrs.lazyLRSEvaluators;

import lrs.*;
import lrs.visitor.*; // skip leading modulo.
import logic.*;

/**
 * Given a filter factor v and a source list src, lazy evaluate  to remove all
 * multiples of v from src.
 */
public class LazyFilterEval extends ALazyEval implements IAlgo, IBooleanAlgo
{
    /** @SBGen Variable (,filter source,,64)   */
    private LRStruct src;
    /** @SBGen Variable (,strategy,,64)   */
    private APredicate aPredStrategy;
    
    public LazyFilterEval(APredicate aPredStrategy, LRStruct src)
    {
        this.src = src;
        this.aPredStrategy = aPredStrategy;
    }
    
    
    public LRStruct nextLRS()
    {
        return makeLRS ();
    }
    
    /**
     * Removes (lazily) all elements from src that don't satisfy the predicate and returns the result.
     * @return a filtered LRStruct.
     */
    public LRStruct makeLRS()
    {
        return (LRStruct) src.execute( this );
    }
    
    public Object emptyCase(LRStruct host, Object... param)
    {
        return (host); // done
    }
    
    public Object nonEmptyCase(LRStruct host, Object... param)
    {
        return (aPredStrategy.isTrue(host.getFirst())).execute(this, host);  //check the predicate
    }
    
    public Object trueCase(IBoolean host, Object... param)
    {
        src = (LRStruct) param[0]; // found beginning of list that satisfies predicate
//   return LRSFactory.Singleton.makeLRS (src.removeFront(), this);
        return makeLazyLRS(src.removeFront());//make list with next value and this evaluator
    }
    
    public Object falseCase(IBoolean host, Object... param)
    {
        return ((LRStruct) param[0]).getRest().execute(this); // keep looking
    }
}

