package lrs.lazyLRSEvaluators;

import fp.*;
import lrs.*;

/**
 * Lazily creates a possibly infinite list that, given two sorted LRStructs
 * of Integers, will contain the elements from both LRStructs sorted. If
 * both LRStructs are non-empty, the first elements will be compared, and the
 * one that is less will be removed and returned as element for the output
 * list.
 */
public class LazyMergeEval extends LazyCombineEval {
    // FOR STUDENT TO COMPLETE: add fields and methods here
    public LazyMergeEval(LRStruct src1, LRStruct src2) {
        super(src1, src2, new ILambda() {
            public Object apply(Object... param) {
                LRStruct src1 = (LRStruct)param[0];
                LRStruct src2 = (LRStruct)param[1];
                Integer i = (Integer)src1.getFirst();
                Integer j = (Integer)src2.getFirst();
                if (i<j) {
                    return src1.removeFront();
                }
                else {
                    return src2.removeFront();
                }
            }
        });
    }
}

