import junit.framework.TestCase;

import lrs.*;
import lrs.lazyLRSEvaluators.*;

public class LazyIncreasingAdderEvalTest extends TestCase {
    private static final IAlgo isE = new IAlgo() {
        public Object emptyCase(LRStruct host, Object... inp) {
            return true;
        }
        public Object nonEmptyCase(LRStruct host, Object... inp) {
            return false;
        }
    };
    
    public static void assertEmpty(LRStruct l) {
        assertTrue((Boolean)l.execute(isE));
    }
    public static void assertNonEmpty(LRStruct l) {
        assertFalse((Boolean)l.execute(isE));
    }
    public static void assertFirst(LRStruct l, int i) {
        assertFalse((Boolean)l.execute(isE));
        assertEquals((Integer)i, (Integer)l.getFirst());
    }
    public static void assertArray(LRStruct l, int...is) {
        for(int i: is) {
            assertFirst(l, i);
            l = l.getRest();
        }
        assertEmpty(l);
    }

    public void testEmpty() {
        LRStruct a = new LRStruct();
        LRStruct res = new LazyIncreasingAdderEval(a).makeLRS();
        assertArray(res);
    }

    public void testOne() {
        LRStruct a = new LRStruct();
        a.insertFront(2);
        LRStruct res = new LazyIncreasingAdderEval(a).makeLRS();
        assertArray(res, 2);
    }

    public void testTwo() {
        LRStruct a = new LRStruct();
        a.insertFront(3);
        a.insertFront(2);
        LRStruct res = new LazyIncreasingAdderEval(a).makeLRS();
        assertArray(res, 2+3);
    }

    public void testThree() {
        LRStruct a = new LRStruct();
        a.insertFront(4);
        a.insertFront(3);
        a.insertFront(2);
        LRStruct res = new LazyIncreasingAdderEval(a).makeLRS();
        assertArray(res, 2+3, 4);
    }
    
    public void testFour() {
        LRStruct a = new LRStruct();
        a.insertFront(5);
        a.insertFront(4);
        a.insertFront(3);
        a.insertFront(2);
        LRStruct res = new LazyIncreasingAdderEval(a).makeLRS();
        assertArray(res, 2+3, 4+5);
    }

    public void testFive() {
        LRStruct a = new LRStruct();
        a.insertFront(6);
        a.insertFront(5);
        a.insertFront(4);
        a.insertFront(3);
        a.insertFront(2);
        LRStruct res = new LazyIncreasingAdderEval(a).makeLRS();
        assertArray(res, 2+3, 4+5+6);
    }

    public void testSix() {
        LRStruct a = new LRStruct();
        a.insertFront(7);
        a.insertFront(6);
        a.insertFront(5);
        a.insertFront(4);
        a.insertFront(3);
        a.insertFront(2);
        LRStruct res = new LazyIncreasingAdderEval(a).makeLRS();
        assertArray(res, 2+3, 4+5+6, 7);
    }

    public void testInf() {
        LRStruct a = new LazyIncEval(2,1).makeLRS();
        LRStruct res = new LazyIncreasingAdderEval(a).makeLRS();
        int cur = 2;
        for(int i=0; i<1000; ++i) {
            int sum = 0;
            for(int j=0; j<2+i; ++j) { sum += (cur++); }
            assertFirst(res, sum);
            assertNonEmpty(res.getRest());
            res = res.getRest();
        }
    }
}
