import junit.framework.TestCase;

import lrs.*;
import lrs.lazyLRSEvaluators.*;

public class LazyNCopiesEvalTest extends TestCase {
    private static final IAlgo isE = new IAlgo() {
        public Object emptyCase(LRStruct host, Object... inp) {
            return true;
        }
        public Object nonEmptyCase(LRStruct host, Object... inp) {
            return false;
        }
    };
    
    public static void assertEmpty(LRStruct l) {
        assertTrue((Boolean)l.execute(isE));
    }
    public static void assertNonEmpty(LRStruct l) {
        assertFalse((Boolean)l.execute(isE));
    }
    public static void assertFirst(LRStruct l, int i) {
        assertFalse((Boolean)l.execute(isE));
        assertEquals((Integer)i, (Integer)l.getFirst());
    }
    
    public void testZero() {
        LRStruct res = new LazyNCopiesEval(1, 0).makeLRS();
        assertEmpty(res);
    }
    
    public void testNeg() {
        LRStruct res = new LazyNCopiesEval(1, -1).makeLRS();
        assertEmpty(res);
    }
    
    public void test1() {
        LRStruct res = new LazyNCopiesEval(1, 1).makeLRS();
        assertFirst(res, 1);
        assertEmpty(res.getRest());
    }
    
    public void test2() {
        LRStruct res = new LazyNCopiesEval(1, 2).makeLRS();
        assertFirst(res, 1);
        assertFirst(res.getRest(), 1);
        assertEmpty(res.getRest().getRest());
    }
    
    public void test3() {
        LRStruct res = new LazyNCopiesEval(1, 3).makeLRS();
        assertFirst(res, 1);
        assertFirst(res.getRest(), 1);
        assertFirst(res.getRest().getRest(), 1);
        assertEmpty(res.getRest().getRest().getRest());
    }
}