import junit.framework.TestCase;

import lrs.*;
import lrs.lazyLRSEvaluators.*;

public class LazySquareEvalTest extends TestCase {
    private static final IAlgo isE = new IAlgo() {
        public Object emptyCase(LRStruct host, Object... inp) {
            return true;
        }
        public Object nonEmptyCase(LRStruct host, Object... inp) {
            return false;
        }
    };
    
    public static void assertEmpty(LRStruct l) {
        assertTrue((Boolean)l.execute(isE));
    }
    public static void assertNonEmpty(LRStruct l) {
        assertFalse((Boolean)l.execute(isE));
    }
    public static void assertFirst(LRStruct l, int i) {
        assertFalse((Boolean)l.execute(isE));
        assertEquals((Integer)i, (Integer)l.getFirst());
    }

    public void testEmpty() {
        LRStruct a = new LRStruct();
        LRStruct res = new LazySquareEval(a).makeLRS();
        assertEmpty(res);
    }

    public void testOne() {
        LRStruct a = new LRStruct();
        a.insertFront(2);
        LRStruct res = new LazySquareEval(a).makeLRS();
        assertFirst(res, 4);
        assertEmpty(res.getRest());
    }

    public void testTwo() {
        LRStruct a = new LRStruct();
        a.insertFront(2);
        a.insertFront(3);
        LRStruct res = new LazySquareEval(a).makeLRS();
        assertFirst(res, 9);
        assertFirst(res.getRest(), 4);
        assertEmpty(res.getRest().getRest());
    }

    public void testInf() {
        LRStruct a = new LazyIncEval(1,1).makeLRS();
        LRStruct res = new LazySquareEval(a).makeLRS();
        for(int i=0; i<1000; ++i) {
            assertFirst(res, (i+1)*(i+1));
            assertNonEmpty(res.getRest());
            res = res.getRest();
        }
    }
}
