package lrs.visitor;

import lrs.*;

import logic.*;



// This class is so the empty node can produce a valid return object that 

// will always fail a compare or equals operation.  Note that the return data 

// compares the local data in the GetMin algorithm.   The other order would have 

// worked however, assuming that Integer.MAX_VALUE is not a valid data value.

public class CompareFalse extends CompareObject

{

  

  private static final IBoolean falseBoolean = BooleanFactory.Singleton.makeBoolean(false);

    // Instantiate itself with the maximum possible integer value

    public CompareFalse() {

        super(Integer.MAX_VALUE);

    }

    

    public IBoolean compare(IComparable x) {

        return falseBoolean;

    }



    public IBoolean equals(IComparable x) {

       return falseBoolean;

    }   

}