package lrs.visitor;



import lrs.*;

import counter.*;



public class LRSSumN implements IAlgo {

  public static final LRSSumN Singleton = new LRSSumN();

  

  private LRSSumN(){ }

  

  private final ICounterAlgo helper = new ICounterAlgo() {

    public Object zeroCase(ICounter cHost, Object... h) {

      return 0.0;

    }

    

    public Object nonZeroCase(ICounter cHost, Object... h){

      return ((Number)((LRStruct)h[0]).getFirst()).doubleValue() + ((Double)((LRStruct)h[0]).getRest().execute(LRSSumN.this, cHost.decrement()));

    }

  };

  

  public Object emptyCase(LRStruct host, Object... param) {

    return 0.0;

  }

  

  public Object nonEmptyCase(LRStruct host, Object... param){

    return  ((ICounter) param[0]).execute(helper, host);

  }  

}



