

package lrs.visitor;



import counter.*;

import lrs.*;



public class NthCdr implements IAlgo {

  

  public static final NthCdr Singleton = new NthCdr();

  private NthCdr() {}

  

  /**

   * @param host LRS to be operated on

   * @param param A counter object

   */

  public Object emptyCase(LRStruct host, Object... param) {

    return(host);

  }

  

  /**

   * @param host LRS to be operated on

   * @param param A counter object

   */

  public Object nonEmptyCase(LRStruct host, Object... param) {

    return( ((ICounter) param[0]).execute(counterAlgo, host) );

  }

  

  private static final ICounterAlgo counterAlgo = new ICounterAlgo() {

    /**

     * @param host counter to be operated on

     * @param param LRS to be operated on

     */

    public Object zeroCase(ICounter chost, Object... param) {

      // param is the host of the null/nonNull cases.

      return(param[0]);

    }

    

    /**

     * @param host counter to be operated on

     * @param param LRS to be operated on

     */

    public Object nonZeroCase(ICounter chost, Object... param) {

      return( ((LRStruct) param[0]).getRest().execute(NthCdr.Singleton, chost.decrement()) );

    }

  };  

}