
package brs;

/**
 * Computes a String representation of the binary tree host so that it can be
 * printed vertically.
 * @author Dung X. Nguyen - Copyright 2000 - All rights reserved.
 */
public class ToString implements IVisitor {
    public final static ToString Singleton = new ToString ();
    
    private ToString () {
    }
    
    /**
     * Returns "[]", a String representation of an empty binary tree.
     * @param host an empty binary tree.
     * @param nu not used.
     * @return String
     */
    public Object emptyCase(BiTree host, Object... nu) {
        return "[]";
    }
    
    /**
     * Computes a String representation of the binary tree host so that it can
     * be printed vertically. There is no '\n' at the end of the String.  Passes
     * appropriate leftmost leading String to a helper visitor to compute the
     * String representations of the left and right subtrees.
     * @param host a non-empty binary tree.
     * @param nu not used.
     * @return String
     */
    public Object nonEmptyCase(BiTree host, Object... nu) {
        String ls
            = (String) host.getLeftSubTree().execute(ToStringHelp.Singleton, "|  ");
        String rs
            = (String)host.getRightSubTree().execute(ToStringHelp.Singleton, "   ");
        return (host.getRootDat() + "\n" + ls + "\n" + rs);
        // EXERCISE FOR STUDENTS: Rewrite using anonymous inner classes.
    }
}

