package brs.visitor;

import brs.*;
import rac.*;
import java.util.*;
import junit.framework.TestCase;


/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class BRSLazyEnumerator_Test extends TestCase {
    
    
    public void test_Enumeration() {
        
        IVisitor algo  = BRSLazyEnumerator.Singleton;
        
        BiTree brs = new BiTree();
        IRAContainer rac = (new LRSQueueFactory()).makeRAC();
        
        Enumeration en  = (Enumeration) brs.execute(algo, rac);
        
        assertFalse("empty BRS", en.hasMoreElements());
        
        brs.insertRoot("a");
        
        String actual = enumToString((Enumeration)brs.execute(BRSLazyEnumerator.Singleton, rac));
        
        assertEquals("1 element tree", "a", actual);
        
        BiTree left = new BiTree();
        left.insertRoot("b");
        brs.setLeftSubTree(left);
        
        actual = enumToString((Enumeration)brs.execute(BRSLazyEnumerator.Singleton, rac));    
        assertEquals("2 element tree", "a b", actual);
        
        BiTree right = new BiTree();
        right.insertRoot("c");
        brs.setRightSubTree(right);
        
        actual = enumToString((Enumeration)brs.execute(BRSLazyEnumerator.Singleton, rac));    
        assertEquals("3 element tree", "a c b", actual);
        
        BiTree child = new BiTree();
        child.insertRoot("d");
        left.setRightSubTree(child);
        
        actual = enumToString((Enumeration)brs.execute(BRSLazyEnumerator.Singleton, rac));    
        assertEquals("4 element tree", "a c b d", actual);
        
        rac = (new LRSStackFactory()).makeRAC();
        actual = enumToString((Enumeration)brs.execute(BRSLazyEnumerator.Singleton, rac));    
        assertEquals("4 element tree with stack", "a b d c", actual);
        
    }
    
    private String enumToString(Enumeration en) {
        String result = "";
        if(en.hasMoreElements()) {
            result += en.nextElement().toString();
            
            while(en.hasMoreElements()) {
                result += " "+en.nextElement().toString();
            }
        }
        return result;
    }
    
}
