package listFW;



/**

 * Defines an immutable list that holds elements of type E.

 * Serves as a host for an algorithm on a list to visit its internal structure.

 * Has a "hook" method to call on the appropriate method of the visitor, making

 * the immutable list structure a framework.

 * @author Dung X. Nguyen

 * @author Stephen B. Wong

 * @since Copyright 2004 - DXN, SBW All rights reserved

 * @stereotype host

 */

public interface IList<E> {

    /**

     * A visitor pattern "hook" method that executes an <code>IListAlgo</code>.

     * @param algo the visitor, the algorithm to be executed.  

     * Any visitor that works on a super type of E is accepted.

     * @param inp a generic input parameter to be used by the algorithm algo.

     * @return <code>Object</code> output from executing the algorithm algo.

     */

    public abstract  <R,P>  R execute(IListAlgo<? super E, R, P> algo, P ... inp);

}



