package listFW.visitor;



import listFW.*;



/**

 * Copies an IList<T> using the an IListFactory<T> supplied as an input parameter 

 */

public class CopyList<T> implements IListAlgo<T,IList<T>, IListFactory<?>> {

    

    public  IMTList<T> emptyCase(IMTList<? extends T> host, IListFactory<?> ... fac) {

        return ((IListFactory<T>)fac[0]).makeEmptyList();  // Generates "unchecked cast" warning

    }

    public    INEList<T> nonEmptyCase(INEList<? extends T> host, IListFactory<?> ... fac) {

        return ((IListFactory<T>)fac[0]).makeNEList( host.getFirst(), host.getRest().execute(this, fac)); // Generates "unchecked cast" warning

    }

}

