package listFW.visitor;



import listFW.*;



/**

 * Reverses a particular kind of list only, but with reduced type safety due to delegating

 * to host instead of rest.

 */

public class ReverseList2<T> implements IListAlgo<T,IList<T>, IListFactory<T>>  {

    

    public IMTList<T> emptyCase(IMTList<? extends T> host, IListFactory<T> ... fac) {

        return fac[0].makeEmptyList();  

    }

    public INEList<T> nonEmptyCase(INEList<? extends T> host, final IListFactory<T> ... fac) {

        return host.execute(new IListAlgo<T,INEList<T>, IList<T>>()  {

            public INEList<T> emptyCase(IMTList<? extends T> h,  IList<T> ... acc) {

                return (INEList<T>)acc[0];  // cast required because delegating to host reduces type safety

            }

            public INEList<T> nonEmptyCase(INEList<? extends T> h,  IList<T>... acc) {

                return h.getRest().execute(this, fac[0].makeNEList(h.getFirst(), acc[0]));

            }

        },fac[0].makeEmptyList());

    }

}





