package listFW.visitor;



import listFW.*;



/**

 * Attempt to reverse any kind of list, but requires that the factory match the list

 * Could have serious problems at run-time due to type erasure

 */

public class ReverseList3 implements IListAlgo<Object,IList<? extends Object>, IListFactory<?>>  {

    

    public IMTList<? extends Object> emptyCase(IMTList<? extends Object> host, IListFactory<?> ... fac) {

        return ((IListFactory<Object>)fac[0]).makeEmptyList();  // Generates "unchecked cast" warning

    }

    public INEList<? extends Object> nonEmptyCase(INEList<? extends Object> host, IListFactory<?> ... fac) {

        final IListFactory<Object> f = (IListFactory<Object>)fac[0];

        return host.getRest().execute(new IListAlgo<Object,INEList<Object>, INEList<Object>>()  {

            public INEList<Object> emptyCase(IMTList<? extends Object> h, INEList<Object> ... acc) {

                return acc[0];

            }

            public INEList<Object> nonEmptyCase(INEList<? extends Object> h, INEList<Object>... acc) {

                return h.getRest().execute(this, f.makeNEList(h.getFirst(), acc[0]));

            }

        },f.makeNEList(host.getFirst(), f.makeEmptyList()));

    }

}





