package lrs.visitor;
import lrs.*;

/**
 * Assigns the input list to the host.
 * host thus "becomes" the input list.
 * In the end, both host and the input list share the same head node.
 */
public class Becomes implements IAlgo {
    public final static Becomes Singleton = new Becomes ();
    private Becomes() {
    }
    
    /**
     * @param input a LRStruct;
     * @return null
     */
    public Object emptyCase(LRStruct host, Object... input) {
        return assign(host, (LRStruct)input[0]);
    }
    
    /**
     * @param input a LRStruct;
     * @return null
     */
    public Object nonEmptyCase(LRStruct host, Object... input) {
        return assign(host, (LRStruct)input[0]);
    }
    
    final private Object assign (LRStruct lhs, LRStruct rhs) {
        lhs.insertFront (null);
        lhs.setRest (rhs);
        lhs.removeFront();
        return null;
    }
}

