package lrs.visitor.test;
import lrs.*;
import lrs.visitor.*;
import junit.framework.TestCase;


public class Splitter_Test extends TestCase {
    
    public void test_Splitter() {
        LRStruct l1 = new LRStruct ();
        LRStruct l2 = (LRStruct)l1.execute(Splitter.Singleton);
        assertEquals("Splitting empty list", "()", l1.toString());
        assertEquals("Splitting empty list", "()", l2.toString());
        
        l1.insertFront (new Integer (-9));
        l1.insertFront (new Integer (15));
        l1.insertFront (new Integer (263));
        l1.insertFront (new Integer (-72));
        l1.insertFront (new Integer (0));
        l2 = (LRStruct)l1.execute(Splitter.Singleton);
        assertEquals("Splitting odd length list", "(0 -72)", l1.toString());
        assertEquals("Splitting odd length list", "(263 15 -9)", l2.toString());
        
        l1.insertFront (new Integer (99));
        l1.insertFront (new Integer (-55));
        l1.insertFront (new Integer (12));
        l1.insertFront (new Integer (48));
        l2 = (LRStruct)l1.execute(Splitter.Singleton);
        assertEquals("Splitting even length list", "(48 12 -55)", l1.toString());
        assertEquals("Splitting even length list", "(99 0 -72)", l2.toString());
    }
    
}
