package rac;

import lrs.*;



public class LRSQueueFactory extends ALRSRACFactory {

    /**

     * Create a ``first-in, first-out'' (FIFO) container.

     */

    public IRAContainer makeRAC() {

        return new LRSRAContainer(new IAlgo() {

            public Object emptyCase(LRStruct host, Object... input) {

                return host.insertFront(input[0]);

            }

            

            public Object nonEmptyCase(LRStruct host, Object... input) {

                return host.getRest().execute(this, input);

            }

        });

        

    }    

}