package rac;

import lrs.*;
import lrs.visitor.*;

import java.util.*;

/*
 * Implements a factory for restricted access containers that
 * return the ``highest priority'' item.
 */
public class PQComparatorRACFactory extends ALRSRACFactory {
    
    private Comparator _comp;
    
    /**
     * Used when the items in the container are Comparable objects.
     */
    public PQComparatorRACFactory() {
        _comp = new Comparator() {
            public int compare(Object x, Object y) {
                /*
                 * Intentionally reverse the ordering so that the
                 * largest item will be first.
                 */
                return ((Comparable)y).compareTo(x);
            }
        };
    }
    
    /**
     * Used when we want to prioritize the items according to a given Comparator.
     * @param comp the item that is smallest according to comp has the highest
     * priority.
     */
    public PQComparatorRACFactory(Comparator comp) {
        _comp = comp;
    }
    
    /**
     * Create a container that returns the item with the highest priority
     * according to a given Comparator.
     */
    public IRAContainer makeRAC() {
        return new LRSRAContainer(new InsertInOrder(_comp));
    }
    
}
