package rac;



import lrs.*;



/*

 * Implements a factory for restricted access containers, including a

 * container that returns a random item.

 */

public class RandomRACFactory extends ALRSRACFactory {

    /**

     * Create a container that returns a random item.

     */

    public IRAContainer makeRAC() {

        return new LRSRAContainer(new IAlgo() {

            public Object emptyCase(LRStruct host, Object... input) {

                return host.insertFront(input[0]);

            }

            

            public Object nonEmptyCase(LRStruct host, Object... input) {

                /*

                 * Math.Random returns a value between 0.0 and 1.0.

                 */

                if (0.5 > Math.random())

                    return host.insertFront(input[0]);

                else

                    return host.getRest().execute(this, input);

            }

        });

    }

}



