package rac.test;
import rac.*;
import rac.visitor.*;

import junit.framework.TestCase;


public class Test_IsEmpty extends TestCase {
    
    
    public void test_RAC() {
        IRACFactory racFac = new LRSStackFactory();
        
        IRAContainer rac = racFac.makeRAC();
        assertEquals("Empty RAC:", Boolean.TRUE, rac.execute(IsEmpty.Singleton));
        
        rac.put("abc");
        assertEquals("Non-empty RAC:", Boolean.FALSE, rac.execute(IsEmpty.Singleton));
        
        rac.put("def");
        assertEquals("Non-empty RAC:", Boolean.FALSE, rac.execute(IsEmpty.Singleton));
        
        rac.get();
        assertEquals("Non-empty RAC:", Boolean.FALSE, rac.execute(IsEmpty.Singleton));
        
        rac.get();
        assertEquals("Empty RAC:", Boolean.TRUE, rac.execute(IsEmpty.Singleton));
    }
    
}
