package treeNTest;

import treeN.*;
import treeNAlgo.*;
import lrs.*;
import fp.*;
import junit.framework.TestCase;

/**
 * A JUnit test case class for the InOrderAlgo visitor
 */
public class Test_InOrderAlgo extends TestCase {
 
  /**
   * Tests creating an ordered LRS on an order 2 tree
   */
  public void test_order2_ConsLRS() {
    ITreeNAlgo traverse = new InOrderAlgo(ConsLRS.Singleton);
    
    TreeN tree = new TreeN();
    ITreeNAlgo insert = new InsertNAlgo(2);
    
    assertEquals("empty tree", "()", tree.execute(traverse, new LRStruct()).toString());
    
    tree.execute(insert, 10);
    assertEquals("1 element tree", "(10)", tree.execute(traverse, new LRStruct()).toString());
    
    tree.execute(insert, 5);
    assertEquals("2 element tree", "(5, 10)", tree.execute(traverse, new LRStruct()).toString());
    
    tree.execute(insert, 7);
    assertEquals("3 element tree", "(5, 7, 10)", tree.execute(traverse, new LRStruct()).toString());

    tree.execute(insert, 20);
    assertEquals("4 element tree", "(5, 7, 10, 20)", tree.execute(traverse, new LRStruct()).toString());
    
    tree.execute(insert, 15);
    assertEquals("5 element tree", "(5, 7, 10, 15, 20)", tree.execute(traverse, new LRStruct()).toString());

    tree.execute(insert, 6);
    assertEquals("6 element tree", "(5, 6, 7, 10, 15, 20)", tree.execute(traverse, new LRStruct()).toString());

    tree.execute(insert, 12);
    assertEquals("7 element tree", "(5, 6, 7, 10, 12, 15, 20)", tree.execute(traverse, new LRStruct()).toString());
  }
  
  /**
   * Tests creating an ordered LRS on an order 5 tree
   */
  public void test_order5_ConsLRS() {
    ITreeNAlgo traverse = new InOrderAlgo(ConsLRS.Singleton);
    
    TreeN tree = new TreeN();
    ITreeNAlgo insert = new InsertNAlgo(5);
    
    assertEquals("empty tree", "()", tree.execute(traverse, new LRStruct()).toString());
    
    tree.execute(insert, 10);
    assertEquals("1 element tree", "(10)", tree.execute(traverse, new LRStruct()).toString());
    
    tree.execute(insert, 5);
    assertEquals("2 element tree", "(5, 10)", tree.execute(traverse, new LRStruct()).toString());
    
    tree.execute(insert, 7);
    assertEquals("3 element tree", "(5, 7, 10)", tree.execute(traverse, new LRStruct()).toString());

    tree.execute(insert, 20);
    assertEquals("4 element tree", "(5, 7, 10, 20)", tree.execute(traverse, new LRStruct()).toString());
    
    tree.execute(insert, 15);
    assertEquals("5 element tree", "(5, 7, 10, 15, 20)", tree.execute(traverse, new LRStruct()).toString());

    tree.execute(insert, 6);
    assertEquals("6 element tree", "(5, 6, 7, 10, 15, 20)", tree.execute(traverse, new LRStruct()).toString());

    tree.execute(insert, 12);
    assertEquals("7 element tree", "(5, 6, 7, 10, 12, 15, 20)", tree.execute(traverse, new LRStruct()).toString());
  }  

  /**
   * Tests summing an order 2 tree
   */
  public void test_order2_Sum() {
    ITreeNAlgo traverse = new InOrderAlgo(Sum.Singleton);
    
    TreeN tree = new TreeN();
    ITreeNAlgo insert = new InsertNAlgo(2);
    
    assertEquals("empty tree", 0, tree.execute(traverse, 0));
    
    tree.execute(insert, 10);
    assertEquals("1 element tree", 10, tree.execute(traverse, 0));
    
    tree.execute(insert, 5);
    assertEquals("2 element tree", 15, tree.execute(traverse, 0));
    
    tree.execute(insert, 7);
    assertEquals("3 element tree", 22, tree.execute(traverse, 0));

    tree.execute(insert, 20);
    assertEquals("4 element tree", 42, tree.execute(traverse, 0));
    
    tree.execute(insert, 15);
    assertEquals("5 element tree", 57, tree.execute(traverse, 0));

    tree.execute(insert, 6);
    assertEquals("6 element tree", 63, tree.execute(traverse, 0));

    tree.execute(insert, 12);
    assertEquals("7 element tree", 75, tree.execute(traverse, 0));
  }
  
  /**
   * Tests summing an order 5 tree
   */
  public void test_order5_Sum() {
    ITreeNAlgo traverse = new InOrderAlgo(Sum.Singleton);
    
    TreeN tree = new TreeN();
    ITreeNAlgo insert = new InsertNAlgo(5);
    
    assertEquals("empty tree", 0, tree.execute(traverse, 0));
    
    tree.execute(insert, 10);
    assertEquals("1 element tree", 10, tree.execute(traverse, 0));
    
    tree.execute(insert, 5);
    assertEquals("2 element tree", 15, tree.execute(traverse, 0));
    
    tree.execute(insert, 7);
    assertEquals("3 element tree", 22, tree.execute(traverse, 0));

    tree.execute(insert, 20);
    assertEquals("4 element tree", 42, tree.execute(traverse, 0));
    
    tree.execute(insert, 15);
    assertEquals("5 element tree", 57, tree.execute(traverse, 0));

    tree.execute(insert, 6);
    assertEquals("6 element tree", 63, tree.execute(traverse, 0));

    tree.execute(insert, 12);
    assertEquals("7 element tree", 75, tree.execute(traverse, 0));  
  }  
}
