package treeNTest;

import treeN.*;
import treeNAlgo.*;

import junit.framework.TestCase;

/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class Test_SetDatAt extends TestCase {
  private ITreeNAlgo toString = ToStringAlgo.Singleton();
  private ITreeNAlgo equals = EqualAlgo.Singleton;
  
  public void test_SetDatAt_empty() {
    ITreeNAlgo set = new SetDatAt(0);
    TreeN tree = new TreeN();
    try {
      tree.execute(set, -99);
      fail("Empty tree should have thrown an exception");
    }
    catch(IllegalArgumentException e) {
      assertEquals("0rder 0 tree", "Cannot set data element 0 of a host tree in state 0!", e.getMessage() );
    }
    catch(Exception e) {
      fail("Wrong exception thrown: "+e);
    }

    set = new SetDatAt(5);
    try {
      tree.execute(set, 42);
      fail("Empty tree should have thrown an exception");
    }
    catch(IllegalArgumentException e) {
      assertEquals("0rder 0 tree", "Cannot set data element 5 of a host tree in state 0!", e.getMessage() );
    }
    catch(Exception e) {
      fail("Wrong exception thrown: "+e);
    }
  
  }

  public void test_SetDatAt_order1() {
    ITreeNAlgo set = new SetDatAt(0);
    TreeN tree1 = new TreeN(42);
    TreeN tree2 = new TreeN(-99);
    tree1.execute(set, -99);

    assertTrue("0rder 1 tree", (Boolean) tree2.execute(equals, tree1));
    
    set = new SetDatAt(1);
    try {
      tree1.execute(set, 314);
      fail("Empty tree should have thrown an exception");
    }
    catch(IllegalArgumentException e) {
      assertEquals("0rder 1 tree", "Cannot set data element 1 of a host tree in state 1!", e.getMessage() );
    }
    catch(Exception e) {
      fail("Wrong exception thrown: "+e);
    }
    
    tree1.spliceAt(1, tree2);
    tree2 = (new TreeN(-99)).spliceAt(1, new TreeN(314));
    tree1.execute(set, 314);
    
    assertTrue("0rder 2 tree", (Boolean) tree2.execute(equals, tree1));
  }
  
}
