package lrs;

import java.awt.*;
/**
 * <<abstract state>>
 * abstract LRS node
 */
abstract class AState
{
  /**
   * @param owner 
   * @return n
   */
  abstract LRStruct getRest(LRStruct owner);
  
  /**
   * @param owner 
   * @return n
   */
  abstract Object getFirst(LRStruct owner);
  
  /**
   * @param tail 
   * @param owner 
   */
  abstract void setRest(LRStruct tail, LRStruct owner);
  
  /**
   * @param dat 
   * @param owner 
   */
  abstract void setFirst(Object dat, LRStruct owner);
  
  /**
   * @param dat 
   * @param owner 
   */
  abstract void insertAsFirst(Object dat, LRStruct owner);
  
  /**
   * @param owner 
   * @return 
   */
  abstract Object removeFirst(LRStruct owner);
  
  abstract Object execute(IAlgo visitor, Object param, LRStruct owner);
  

}

