package treeNAlgo;
import treeN.*;
import java.util.*;

/**
 * An implementation of ITreeNAlgo that uses a hash table (hashmap) to 
 * store commands associated with each possible case of the TreeN host.
 */
public abstract class AHashTreeAlgo implements ITreeNAlgo {
  
  
  /**
   * Public interface for TreeN algo commands to be stored in this visitor 
   */
  public interface ITACmd {
    /*
     * Method to be invoked when this method is accessed.
     * @param i The state of the host, supplied by the host.
     * @param host The host TreeN
     * @param param  An arbitrary input parameter
     * @return The return value of the visitor
     */
    public Object apply(int i, TreeN host, Object param);
  }
  
  // TODO:  STUDENT TO ADD ANY NECESSARY FIELDS
  // Be sure to initialize any fields to viable values!
  
  private HashMap<Integer, ITACmd> _hashMap = new HashMap<Integer, ITACmd>();
  
  private ITACmd _defaultCmd = new ITACmd() {
    public Object apply(int i, TreeN host, Object param) {
      return null;
    }
  };
  
  /**
   * Sets the command for state i to the given command
   * @param i The state for which the command is to be associated
   * @param cmd The ITACmd to be set
   */
  public void setCmdAt(int i, ITACmd cmd) {
    // TODO:  STUDENT TO ADD METHOD BODY
    _hashMap.put(i, cmd);
  }
  
  /**
   * Sets the default command of the visitor to the given command
   * @param defCmd The default command to be set
   */
  public void setDefaultCmd(ITACmd defCmd) {
    // TODO:  STUDENT TO ADD METHOD BODY
    _defaultCmd = defCmd;
  }
  
  /**
   * Finds the stored command associated with state i and returns the
   * result of calling its apply method with the given input parameters.
   * If no corresponding command is found, then the default command is used.
   * @param  The state of the host
   * @param host The host TreeN
   * @param param param an arbitrary input parameter to be used by the visitor.
   * @return The return value of the associated command's apply() method.
   */
  public Object caseAt(int i, TreeN host, Object param) {
    // TODO:  STUDENT TO ADD METHOD BODY
    ITACmd cmd = _hashMap.get(i);
    if(cmd == null) return _defaultCmd.apply(i, host, param);
    else return cmd.apply(i, host, param);
  }
}

