package treeNAlgo;

import treeN.*;

/**
 * InsertNAlgo  -  inserts the supplied parameter (key) into a TreeN
 *  preserving balance with a maximum number of elements per node.
 * @dependency treeNAlgo.ILambda instantiates
 */
public class InsertNAlgo2 extends AHashTreeAlgo {
  // TODO: STUDENT TO ADD ANY NECESSARY FIELDS AND/OR METHODS
  
  /**
   * 
   * @param order -- the max possible number of elements in a node
   */ 
  public InsertNAlgo2(final int order) {
    // TODO: STUDENT TO FILL IN CODE HERE
    
    setDefaultCmd(new ITACmd() {

      private SplitUpAndApply splitUpAndSplice = new SplitUpAndApply(order);
      
      
      public Object apply(int i, final TreeN host, final Object key) {
        host.execute(new AHashTreeAlgo(){ 
          
          private AHashTreeAlgo help = this;
          
          {
            setDefaultCmd(new ITACmd() {
              public Object apply(int s_help, final TreeN h, Object cmd) {
                final int[] x={0};  // trick to get past restrictions on final
                // x[0] is the index of insertion location.
                for(; x[0] < s_help; x[0]++) {// find insertion location
                  int d = h.getDat(x[0]).intValue();
                  if (d >= ((Integer)key).intValue()) {
                    if (d == ((Integer)key).intValue())
                      return h; // no duplicate keys allowed
                    else break;
                  }
                }
                h.getChild(x[0]).execute(help, new ILambda() {
                  /**
                   * @param child a TreeN subtree of h.
                   */
                  public Object apply(Object child){
                    // splice child tree into parent
                    return h.spliceAt(x[0],
                                      (TreeN) child);
                  }
                });
                // split up host if necessary
                return h.execute(splitUpAndSplice, cmd);          
              }
            });
            setCmdAt(0, new ITACmd() {
              public Object apply(int s_help, final TreeN h, Object cmd) {
                /**
                 * At this point the host is an empty subtree of some parent
                 * tree. Because the parent tree is balanced, it must be a
                 * leaf!
                 */
                return ((ILambda)cmd).apply(new TreeN((Integer)key));              }
            });
          }
        }, new ILambda() {// say something meaningful here
          /**
           * @param child not used.
           */
          public Object apply(Object child){
            return host;  //no-op for this one
          }
        });
        return host;
      }
    });
    
    setCmdAt(0, new ITACmd() {
      public Object apply(int i, TreeN host, Object key) {
        return host.spliceAt(0, new TreeN((Integer) key));
      }
    });
  }   
}
