package treeNAlgo;

import treeN.*;


public class SetDatAt extends AHashTreeAlgo {
  
  public SetDatAt(final int target) {
    setDefaultCmd(new ITACmd() {
      public Object apply(int i, TreeN host, final Object val) {
        if(target >= i) throw new IllegalArgumentException("Cannot set data element "+target+" of a host tree in state "+i+"!");
        
        TreeN left = host.getChild(target);
        final TreeN right = host.getChild(1+target);
        
        TreeN newTree = (TreeN) left.execute(new AHashTreeAlgo(){
          {
            setDefaultCmd( new ITACmd() {
              public Object apply(int i, final TreeN leftHost, final Object tree) {
                leftHost.spliceAt(i, new TreeN((Integer) val));
                leftHost.splitUpAt(i);
                leftHost.spliceAt(1,right);
                leftHost.splitUpAt(0);
                return leftHost;
              }
            });
          }}, null);
          
          host.splitDownAt(target);
          host.spliceAt(target, newTree);
          return host;
      }
    });
  }

  
}
  
