package treeNAlgo;

import treeN.*;

/**
 * Splits host upwards if its state &gt; order and passes the host to the
 * supplied param, which is an ISpliceCmd, to do some "abstract splicing".
 * @dependency treeNAlgo.ILambda uses
 */
class SplitUpAndApply implements ITreeNAlgo {
  
  private int _order;
  /**
   * Installs no-op cmd for states <= order
   */
  public SplitUpAndApply(int order) {
    _order = order;
  }
  
  public Object caseAt(int s, TreeN host, Object cmd) {
    if (s <= _order) {
      return host;
    }
    else {
      host.splitUpAt(s/2);   // push data up
      return ((ILambda)cmd).apply(host); // "splice" host into something!
    }
  }
  
}

