package treeNTest;

import treeN.*;
import treeNAlgo.*;
import junit.framework.TestCase;

/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class Test_EqualAlgo extends TestCase {

  ITreeNAlgo equals = EqualAlgo.Singleton;
  
  public void test_empty() {
    TreeN t1 = new TreeN();
    TreeN t2 = new TreeN();
    
    assertTrue("2 empty trees", (Boolean) t1.execute(equals, t2));
    
    t2 = new TreeN(42);
    
    assertFalse("1 empty tree, 1 non-empty", (Boolean) t1.execute(equals, t2));
    assertFalse("1 empty tree, 1 non-empty", (Boolean) t2.execute(equals, t1));
  }

  public void test_nonEmpty() {
    TreeN t1 = new TreeN(3);
    TreeN t2 = new TreeN(3);
    
    assertTrue("2 non-empty trees", (Boolean) t1.execute(equals, t2));
    
    t2 = new TreeN(42);
    
    assertFalse("2 non-empty", (Boolean) t1.execute(equals, t2));
    assertFalse("2 non-empty", (Boolean) t2.execute(equals, t1));
    
    t1 = t1.spliceAt(1, t2);
    assertFalse("2 non-empty", (Boolean) t1.execute(equals, t2));
    assertFalse("2 non-empty", (Boolean) t2.execute(equals, t1));
    
    t2 = (new TreeN(3)).spliceAt(1, new TreeN(42));
    assertTrue("2 non-empty trees", (Boolean) t1.execute(equals, t2));
    
    t2 = (new TreeN(3)).spliceAt(1, new TreeN(-42));
    assertFalse("2 non-empty", (Boolean) t1.execute(equals, t2));
    assertFalse("2 non-empty", (Boolean) t2.execute(equals, t1));
    
    t1.splitDownAt(0);
    assertFalse("2 non-empty", (Boolean) t1.execute(equals, t2));
    assertFalse("2 non-empty", (Boolean) t2.execute(equals, t1));
    
    t2 = ((new TreeN(3)).spliceAt(1, new TreeN(42))).splitDownAt(0);
    assertTrue("2 non-empty trees", (Boolean) t1.execute(equals, t2));
    
    t1.spliceAt(1, new TreeN(99));
    t2.spliceAt(1, new TreeN(99));
    assertTrue("2 non-empty trees", (Boolean) t1.execute(equals, t2));

    t1.splitDownAt(1);
    assertFalse("2 non-empty", (Boolean) t1.execute(equals, t2));
    assertFalse("2 non-empty", (Boolean) t2.execute(equals, t1));

    t2.splitDownAt(1);
    assertTrue("2 non-empty trees", (Boolean) t1.execute(equals, t2));

  }
  
}
