package treeNTest;

import treeN.*;
import treeNAlgo.*;
import junit.framework.TestCase;

/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class Test_InsertNAlgo extends TestCase {
  
  public void test_order2() {
    ITreeNAlgo insert = new InsertNAlgo2(2);
  
    TreeN t1 = new TreeN();
    t1.execute(insert, 5);
    TreeN t2 = new TreeN(5);
   
    assertEquals("one element", t2.toString(), t1.toString());

    t1.execute(insert, 10);
    t2.spliceAt(1, new TreeN(10));
    assertEquals("two elements", t2.toString(), t1.toString());

    t1.execute(insert, 7);
    t2 = (new TreeN(5)).spliceAt(1, new TreeN(7)).spliceAt(2, new TreeN(10)).splitUpAt(1);
    assertEquals("three elements", t2.toString(), t1.toString());
    
    t1.execute(insert, 3);
    t2 = (new TreeN(3)).spliceAt(1, new TreeN(5)).spliceAt(2, new TreeN(7)).spliceAt(3, new TreeN(10)).splitUpAt(2);
    assertEquals("four elements", t2.toString(), t1.toString());
    
    t1.execute(insert, 15);
    t2 = (new TreeN(3)).spliceAt(1, new TreeN(5)).spliceAt(2, new TreeN(7)).spliceAt(3, new TreeN(10)).spliceAt(4, new TreeN(15)).splitUpAt(2);
    
    assertEquals("five elements", t2.toString(), t1.toString());
    
    t1.execute(insert, 4);
    t2 = (new TreeN(3)).spliceAt(1, new TreeN(4)).spliceAt(2, new TreeN(5)).spliceAt(3, new TreeN(7)).spliceAt(4, new TreeN(10)).spliceAt(5, new TreeN(15)).splitUpAt(3);
    t2.getChild(0).splitUpAt(1);
    t2.spliceAt(0, t2.getChild(0));
    
    assertEquals("six elements", t2.toString(), t1.toString());
    
    t1.execute(insert, 20);
    t2.getChild(2).spliceAt(2, new TreeN(20)).splitUpAt(1);
    t2.spliceAt(2, t2.getChild(2)).splitUpAt(1);
    
    assertEquals("seven elements", t2.toString(), t1.toString());    
  }

  
  public void test_order5() {
    ITreeNAlgo insert = new InsertNAlgo2(5);
  
    TreeN t1 = new TreeN();
    t1.execute(insert, 5);
    TreeN t2 = new TreeN(5);
   
    assertEquals("one element", t2.toString(), t1.toString());

    t1.execute(insert, 10);
    t2.spliceAt(1, new TreeN(10));
    assertEquals("two elements", t2.toString(), t1.toString());

    t1.execute(insert, 7);
    t2 = (new TreeN(5)).spliceAt(1, new TreeN(7)).spliceAt(2, new TreeN(10));
    assertEquals("three elements", t2.toString(), t1.toString());
    
    t1.execute(insert, 3);
    t2 = (new TreeN(3)).spliceAt(1, new TreeN(5)).spliceAt(2, new TreeN(7)).spliceAt(3, new TreeN(10));
    assertEquals("four elements", t2.toString(), t1.toString());
    
    t1.execute(insert, 15);
    t2 = (new TreeN(3)).spliceAt(1, new TreeN(5)).spliceAt(2, new TreeN(7)).spliceAt(3, new TreeN(10)).spliceAt(4, new TreeN(15));
    
    assertEquals("five elements", t2.toString(), t1.toString());
    
    t1.execute(insert, 4);
    t2 = (new TreeN(3)).spliceAt(1, new TreeN(4)).spliceAt(2, new TreeN(5)).spliceAt(3, new TreeN(7)).spliceAt(4, new TreeN(10)).spliceAt(5, new TreeN(15)).splitUpAt(3);
    t2.splitUpAt(3);
    
    assertEquals("six elements", t2.toString(), t1.toString());
    
    t1.execute(insert, 20);
    t2.getChild(1).spliceAt(2, new TreeN(20));

    assertEquals("seven elements", t2.toString(), t1.toString());    
  }
  
}
